#ifndef _SELECT_CONDITIONS_H_
#define _SELECT_CONDITIONS_H_

#include <GSTCore/GST_types.h>
#include <buildspec.h>
using GST::GSTCore::GSTbox;

namespace GST
{
namespace ClientUtils
{
/** Condition base class as select condition of a feature */
class GST_API_EXPORT ICondition{public: virtual ~ICondition(){}};

/** Type: inside_box Condition. Use to select object inside x,y,z min max
 * values. */
class GST_API_EXPORT BoxCondition : public ICondition
{
public:
	double xmin, xmax, ymin, ymax, zmin, zmax;

	BoxCondition(const GSTbox &box)
		: xmin(box.xmin)
		, xmax(box.xmax)
		, ymin(box.ymin)
		, ymax(box.ymax)
		, zmin(box.zmin)
		, zmax(box.zmax)
	{
	}
};

/** Type: lock Condition for LTin. borderSize specifies the soft locked border
 * size.*/
class GST_API_EXPORT SoftLockCondition : public ICondition
{
public:
	int borderSize;

	SoftLockCondition(int bs) : borderSize(bs)
	{
	}
};

/** Type: This is true if the user wants all level of object. */
class GST_API_EXPORT LODCondition : public ICondition
{
public:
	bool isRequestOnAllLevel;

	LODCondition(bool all) : isRequestOnAllLevel(all)
	{
	}
};

class GST_API_EXPORT VersionCondition : public ICondition
{
public:
	int version;

	VersionCondition(int v) : version(v)
	{
	}
};

} // namespace ClientUtils
} // namespace GST

#endif //_SELECT_CONDITIONS_H_
